#pragma once

#include <library/cpp/monlib/metrics/metric_registry.h>

namespace NSolomon {

class TQueueMetrics {
public:
    TQueueMetrics(NMonitoring::IMetricFactory& metrics, TStringBuf name, size_t queueSizeLimit) {
        TString prefix = TString{"httpClient."} + name;
        QueueSize_ = metrics.IntGauge(NMonitoring::MakeLabels<TString>({{"sensor", prefix + ".size"}}));
        Enqueued_ = metrics.Rate(NMonitoring::MakeLabels<TString>({{"sensor", prefix + ".enqueued"}}));
        Dequeued_ = metrics.Rate(NMonitoring::MakeLabels<TString>({{"sensor", prefix + ".dequeued"}}));
        Dropped_ = metrics.Rate(NMonitoring::MakeLabels<TString>({{"sensor", prefix + ".dropped"}}));

        if (queueSizeLimit) {
            metrics.IntGauge(NMonitoring::MakeLabels<TString>({{"sensor", prefix + ".limit"}}))->Set(queueSizeLimit);
        }
    }

    void Enqueue() const noexcept {
        Enqueued_->Inc();
        QueueSize_->Inc();
    }

    void Dequeue() const noexcept {
        Dequeued_->Inc();
        QueueSize_->Dec();
    }

    void Drop() const noexcept {
        Dropped_->Inc();
    }

private:
    NMonitoring::IIntGauge* QueueSize_;
    NMonitoring::IRate* Enqueued_;
    NMonitoring::IRate* Dequeued_;
    NMonitoring::IRate* Dropped_;
};

} // namespace NSolomon
