#pragma once

#include "headers.h"

#include <util/generic/size_literals.h>

namespace NSolomon {

class TResponse final: public IResponse {
public:
    TResponse() {
        Data_.reserve(16_KB);
    }

    HttpCodes Code() const override {
        return Code_;
    }

    TStringBuf Data() const override {
        return Data_;
    }

    TString ExtractData() override {
        return std::move(Data_);
    }

    const IHeaders& Headers() const override {
        return Headers_;
    }

public:
    HttpCodes Code_{HTTP_CODE_MAX}; // NOLINT(readability-identifier-naming)
    TString Data_; // NOLINT(readability-identifier-naming)
    THeaders Headers_; // NOLINT(readability-identifier-naming)
};

} // namespace NSolomon
