#pragma once

#include <util/generic/noncopyable.h>

#include <curl/curl.h>

namespace NSolomon {

class TCurlShare: private TNonCopyable {
public:
    TCurlShare() noexcept
        : Share_{curl_share_init()}
    {
        CurlShareSet(Share_, CURLSHOPT_UNSHARE, CURL_LOCK_DATA_DNS);
        CurlShareSet(Share_, CURLSHOPT_UNSHARE, CURL_LOCK_DATA_CONNECT);
    }

    ~TCurlShare() noexcept {
        auto ret = curl_share_cleanup(Share_);
        Y_VERIFY(ret == CURLSHE_OK);
    }

    CURLSH* Get() const noexcept {
        return Share_;
    }

private:
    template <typename... TArgs>
    void CurlShareSet(CURLSH* share, CURLSHoption opt, TArgs&&... args) {
        auto ret = curl_share_setopt(share, opt, std::forward<TArgs>(args)...);
        Y_VERIFY(ret == CURLSHE_OK);
    }

private:
    CURLSH* Share_;
};

} // namespace NSolomon
