#include <solomon/libs/cpp/http/client/curl/handle_pool.h>

#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;

NMonitoring::TMetricRegistry REGISTRY;

TEST(THandlePoolTest, Empty) {
    auto pool = CreateHandlePool(REGISTRY);
    ASSERT_TRUE(pool);

    auto stats = pool->Stats();
    EXPECT_EQ(stats.TotalSize, 0u);
    EXPECT_EQ(stats.HandlesUsed, 0u);
    EXPECT_EQ(stats.HandlesAvailable, 0u);
}

TEST(THandlePoolTest, CreateAndReleaseHandle) {
    auto pool = CreateHandlePool(REGISTRY);
    ASSERT_TRUE(pool);

    {
        auto handle = pool->GetHandle();
        ASSERT_TRUE(handle);
        ASSERT_TRUE(handle->Handle());

        auto stats = pool->Stats();
        EXPECT_EQ(stats.TotalSize, 1u);
        EXPECT_EQ(stats.HandlesUsed, 1u);
        EXPECT_EQ(stats.HandlesAvailable, 0u);
    }

    auto stats = pool->Stats();
    EXPECT_EQ(stats.TotalSize, 1u);
    EXPECT_EQ(stats.HandlesUsed, 0u);
    EXPECT_EQ(stats.HandlesAvailable, 1u);
}

TEST(THandlePoolTest, ReuseHandle) {
    auto pool = CreateHandlePool(REGISTRY);
    ASSERT_TRUE(pool);

    void* prevHandle;
    {
        auto handle = pool->GetHandle();
        prevHandle = handle->Handle();
    }
    {
        auto handle = pool->GetHandle();
        ASSERT_EQ(handle->Handle(), prevHandle);
    }
    {
        auto handle = pool->GetHandle();
        ASSERT_EQ(handle->Handle(), prevHandle);
    }
}
