#include <solomon/libs/cpp/http/client/curl/poller.h>

#include <library/cpp/monlib/metrics/metric_registry.h>
#include <library/cpp/testing/gtest/gtest.h>

#include <util/network/pair.h>
#include <util/network/socket.h>

using namespace NSolomon;

static TInstant SmallDeadLine() {
    return TDuration::MilliSeconds(10).ToDeadLine();
}

TEST(TPollerTest, InEvent) {
    SOCKET sockets[2];
    ASSERT_EQ(SocketPair(sockets), 0);

    TSocketHolder s1(sockets[0]);
    TSocketHolder s2(sockets[1]);

    NMonitoring::TMetricRegistry registry;
    TCurlSocketPoller poller{registry};
    poller.AddWait(sockets[1], CURL_POLL_IN, (void*) 17);

    static constexpr auto MAX_POLL = 10;
    void* events[MAX_POLL];
    int filters[MAX_POLL];

    // no events before
    ASSERT_EQ(0u, poller.WaitD(events, filters, std::size(events), SmallDeadLine()));
    ASSERT_EQ(0u, poller.WaitD(events, filters, std::size(events), SmallDeadLine()));

    for (char x = 42; x < 52; ++x) {
        {
            char buf[] = {x};
            ASSERT_EQ(1, send(sockets[0], buf, 1, 0));
        }

        // only one event available after send
        ASSERT_EQ(1u, poller.WaitD(events, filters, std::size(events), SmallDeadLine()));
        ASSERT_EQ((void*) 17, events[0]);
        ASSERT_EQ(CURL_CSELECT_IN, filters[0]);

        {
            char buf[] = {0};
            ASSERT_EQ(1, recv(sockets[1], buf, 1, 0));
            ASSERT_EQ(x, buf[0]);
        }

        // no more events available
        ASSERT_EQ(0u, poller.WaitD(events, filters, std::size(events), SmallDeadLine()));
        ASSERT_EQ(0u, poller.WaitD(events, filters, std::size(events), SmallDeadLine()));
    }
}
