#include <solomon/libs/cpp/http/client/curl/postponed_queue.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;

struct TPostponedQueueTest: public ::testing::Test {
    static constexpr size_t MaxSize{10};

    NMonitoring::TMetricRegistry Registry;
    TPostponedQueue<int> Queue{Registry};
};

TEST_F(TPostponedQueueTest, Empty) {
    ASSERT_FALSE(Queue.Pop());
    ASSERT_EQ(Queue.NextDeadline(), TInstant::Max());
}

TEST_F(TPostponedQueueTest, SingleItem) {
    Queue.Push(std::make_unique<int>(42), TInstant::Seconds(10));

    ASSERT_EQ(Queue.NextDeadline(), TInstant::Seconds(10));

    auto val = Queue.Pop();
    ASSERT_EQ(*val, 42);

    ASSERT_FALSE(Queue.Pop());
    ASSERT_EQ(Queue.NextDeadline(), TInstant::Max());
}

TEST_F(TPostponedQueueTest, OrderByDeadLine) {
    Queue.Push(std::make_unique<int>(1), TInstant::Seconds(10));
    Queue.Push(std::make_unique<int>(2), TInstant::Seconds(20));
    Queue.Push(std::make_unique<int>(3), TInstant::Seconds(5));
    Queue.Push(std::make_unique<int>(4), TInstant::Seconds(15));

    {
        ASSERT_EQ(Queue.NextDeadline(), TInstant::Seconds(5));
        auto val = Queue.Pop();
        ASSERT_EQ(*val, 3);
    }
    {
        ASSERT_EQ(Queue.NextDeadline(), TInstant::Seconds(10));
        auto val = Queue.Pop();
        ASSERT_EQ(*val, 1);
    }
    {
        ASSERT_EQ(Queue.NextDeadline(), TInstant::Seconds(15));
        auto val = Queue.Pop();
        ASSERT_EQ(*val, 4);
    }
    {
        ASSERT_EQ(Queue.NextDeadline(), TInstant::Seconds(20));
        auto val = Queue.Pop();
        ASSERT_EQ(*val, 2);
    }

    ASSERT_FALSE(Queue.Pop());
    ASSERT_EQ(Queue.NextDeadline(), TInstant::Max());
}
