#include <solomon/libs/cpp/http/client/curl/request_queue.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;

struct TRequestQueueTest: public ::testing::Test {
    static constexpr size_t MaxSize{10};

    NMonitoring::TMetricRegistry Registry;
    TRequestQueue<int> Queue{Registry, MaxSize};
};

TEST_F(TRequestQueueTest, Empty) {
    ASSERT_TRUE(Queue.IsEmpty());

    auto value = Queue.Dequeue();
    ASSERT_FALSE(value);
}

TEST_F(TRequestQueueTest, EnqueueAndDequeue) {
    auto value = Queue.TryEnqueue(std::make_unique<int>(42));
    ASSERT_FALSE(value);
    ASSERT_FALSE(Queue.IsEmpty());

    value = Queue.Dequeue();
    ASSERT_TRUE(value);
    ASSERT_EQ(*value, 42);
    ASSERT_TRUE(Queue.IsEmpty());
}

TEST_F(TRequestQueueTest, Overflow) {
    for (size_t i = 0; i < MaxSize; i++) {
        auto value = Queue.TryEnqueue(std::make_unique<int>(i));
        ASSERT_FALSE(value);
    }

    // new value is not enqueued

    auto value = Queue.TryEnqueue(std::make_unique<int>(127));
    ASSERT_TRUE(value);
    ASSERT_EQ(*value, 127);

    // make some room in the queue

    auto zero = Queue.Dequeue();
    ASSERT_TRUE(value);
    ASSERT_EQ(*zero, 0);

    // now enqueue has taken place

    value = Queue.TryEnqueue(std::move(value));
    ASSERT_FALSE(value);
}
