#pragma once

#include <util/generic/string.h>

namespace NSolomon {
    class TRequestError {
    public:
        enum class EType {
            Unknown = 0,
            ConnectFailed,
            ReadTimeout,
            ResponseTooLarge,
            DnsFailure,
            UnsupportedProtocol,
            UrlMalformat,
            SocketError,
            RequestInitializationFailed,
            RequestQueueOverflow,
        };

        TRequestError(EType type, TString errorMsg)
            : Type_{type}
            , Message_{std::move(errorMsg)}
        {
        }

        EType Type() const {
            return Type_;
        }

        const TString& Message() const {
            return Message_;
        }

    private:
        EType Type_{EType::Unknown};
        TString Message_;
    };
} // namespace NSolomon
