#pragma once

#include "handler.h"

#include <solomon/libs/cpp/actors/fwd.h>
#include <solomon/libs/cpp/http/server/config/http_server_config.pb.h>

namespace NSolomon::NHttp {

class THttpServer {
public:
    THttpServer(
            TActorRuntime& runtime,
            std::weak_ptr<NMonitoring::TMetricRegistry> metrics,
            const yandex::monitoring::HttpServerConfig& config);

    NActors::TActorId Handle(const TString& path, std::unique_ptr<NActors::IActor> handler);
    NActors::TActorId Handle(const std::set<TString>& paths, std::unique_ptr<NActors::IActor> handler);

    template <ReqHandleToStr TReqHandler>
    void Handle(const TString& path, TReqHandler&& handler) {
        Handle(path, std::make_unique<TSyncHandler<TReqHandler>>(std::forward<TReqHandler>(handler)));
    }

    template <ReqHandleToResp TReqHandler>
    void Handle(const TString& path, TReqHandler&& handler) {
        Handle(path, std::make_unique<TSyncHandler<TReqHandler>>(std::forward<TReqHandler>(handler)));
    }

    template <ReqHandleFactory TFactory>
    void HandleAsync(const TString& path, TFactory&& factory) {
        Handle(path, std::make_unique<TAsyncHandler<TFactory>>(std::forward<TFactory>(factory)));
    }

    template <AsyncReqHandler THandler>
    void HandleAsync(const TString& path) {
        Handle(path, std::make_unique<TSimpleAsyncHandler<THandler>>());
    }

    ui32 ExecutorId() const noexcept {
        return ExecutorId_;
    }

    NActors::TActorId Proxy() const noexcept {
        return Proxy_;
    }

private:
    NActors::TActorSystem& ActorSystem_;
    ui32 ExecutorId_;
    NActors::TActorId Proxy_;
};

} // namespace NSolomon::NHttp
