#pragma once

#include <library/cpp/actors/http/http_proxy.h>

namespace NSolomon::NHttp {

inline ::NHttp::THttpOutgoingResponsePtr NotAllowed(::NHttp::THttpIncomingRequest& req) {
    return req.CreateResponse("405", "Method Not Allowed");
}

inline ::NHttp::THttpOutgoingResponsePtr Unauthorized(::NHttp::THttpIncomingRequest& req) {
    return req.CreateResponse("401", "Unauthorized");
}

inline ::NHttp::THttpOutgoingResponsePtr Forbidden(::NHttp::THttpIncomingRequest& req) {
    return req.CreateResponse("403", "Forbidden");
}

} // namespace NSolomon::NHttp
