#pragma once

#include <solomon/libs/cpp/auth/core/internal_authorizer.h>

#include <library/cpp/actors/http/http_proxy.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

namespace NSolomon::NHttp {

struct TMetricsAuthorizationConfig {
    NActors::TActorId AuthenticationActor;
    NSolomon::NAuth::IInternalAuthorizerPtr Authorizer;
    bool AuthenticationOff = false;
};

class TMetricsHandler {
public:
    explicit TMetricsHandler(const std::shared_ptr<NMonitoring::IMetricSupplier>& metrics) noexcept
        : Metrics_{*metrics}
    {
    }

    explicit TMetricsHandler(NMonitoring::IMetricSupplier& metrics) noexcept
        : Metrics_{metrics}
    {
    }

    ::NHttp::THttpOutgoingResponsePtr operator()(const ::NHttp::THttpIncomingRequestPtr& req);

private:
    NMonitoring::IMetricSupplier& Metrics_;
};

/**
 * Register supplier in http handler for metrics.
 * NOTE: this function must be called inside actor context.
 *
 * @param metrics metrics supplier
 */
void RegisterMetricSupplier(const std::shared_ptr<NMonitoring::IMetricSupplier>& metrics);

/**
 * Create http handler for dumping all registered metrics suppliers.
 *
 * @param metrics main metrics supplier
 * @return new actor instance
 */
std::unique_ptr<NActors::IActor> CreateMetricsHandler(
        std::shared_ptr<NMonitoring::IMetricSupplier> metrics,
        TMetricsAuthorizationConfig authorizationConfig = {});

std::unique_ptr<NActors::IActor> CreateAuxMetricsHandler(
        std::shared_ptr<NMonitoring::IMetricSupplier> metrics,
        TMetricsAuthorizationConfig authorizationConfig = {});

} // namespace NSolomon::NHttp
