#include <solomon/libs/cpp/id_validator/validator.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;

auto v = CreateIdValidator();

TEST(TIdValidatorTest, EmptyOrBlank) {
    ASSERT_TRUE(v->ValidateShardId("").Fail());
    ASSERT_TRUE(v->ValidateShardId(" ").Fail());
    ASSERT_TRUE(v->ValidateShardId("\t\t").Fail());
    ASSERT_TRUE(v->ValidateShardId("\r\n").Fail());
}

TEST(TIdValidatorTest, IdLength) {
    auto id = TString{};
    id.resize(255, 'a');
    ASSERT_TRUE(v->ValidateShardId(id).Fail());

    id.resize(179, 'a');
    ASSERT_TRUE(v->ValidateShardId(id).Success());
}

TEST(TIdValidatorTest, ReservedNames) {
    for (auto id: {"new", "protoNew"}) {
        ASSERT_TRUE(v->ValidateShardId(id).Fail());
    }

    ASSERT_TRUE(v->ValidateShardId("newShard").Success());
    ASSERT_TRUE(v->ValidateShardId("newprotoNew").Success());
}

TEST(TIdValidatorTest, RestrictedChars) {
    ASSERT_TRUE(v->ValidateShardId("myshard").Success());
    ASSERT_TRUE(v->ValidateShardId("MyShard19").Success());
    ASSERT_TRUE(v->ValidateShardId("<script>shard</script>").Fail());
    ASSERT_TRUE(v->ValidateShardId("my/shard").Fail());
    ASSERT_TRUE(v->ValidateShardId("...").Fail());
}
