#pragma once

#include <solomon/libs/cpp/error_or/error_or.h>

#include <util/generic/ptr.h>

namespace NSolomon {
    class IIdValidator {
    public:
        virtual ~IIdValidator() = default;
        virtual TErrorOr<void, TGenericError> ValidateShardId(const TString& shardId) const = 0;
        virtual TErrorOr<void, TGenericError> ValidateId(const TString& id) const = 0;
    };

    using IIdValidatorPtr = THolder<IIdValidator>;

    IIdValidatorPtr CreateIdValidator();
} // namespace NSolomon
