#pragma once

#include "str_pool.h"

namespace NSolomon::NIntern {

/**
 * Another realisation of Pool to replace string objects by 4-bytes unique identificators
 *      which supports strings removing.
 * Source version you can find: solomon/libs/cpp/intern/str_pool.h
 * This pool uses TVector<TString> to store and flat_hash_map to index strings.
 *
 * All operations have O(1) complexity.
 * This pool is not thread-safe right now.
 */
struct THashMapStringPool {
public:
    THashMapStringPool();
    ~THashMapStringPool();

    TStringId Intern(TStringBuf strBuf);

    TStringBuf Find(TStringId id) const noexcept;

    TStringId Find(TStringBuf strBuf) const noexcept;

    size_t Size() const noexcept;

    size_t AllocatedBytes() const noexcept;

    void Remove(TStringId id);

private:
    struct TImpl;
    THolder<TImpl> Impl_;
};

} // namespace NSolomon::NIntern
