#include <solomon/libs/cpp/intern/rb_tree.h>

#include <library/cpp/testing/gtest/gtest.h>

namespace {

struct TTestNode: public NSolomon::NIntern::TRbTreeNode<ui32, TTestNode> {
    using TBase = TRbTreeNode<ui32, TTestNode>;

    ui32 Value;

    TTestNode(ui32 key, ui32 value)
        : TBase(key)
        , Value(value)
    {
    }
};

} // namespace

using TTestTree = NSolomon::NIntern::TRbTree<ui32, TTestNode>;

TEST(TRbTreeTest, TaggedPtr) {
    using NSolomon::NIntern::NPrivate::TTaggedPtr;

    int x = 42;
    int y = 24;

    TTaggedPtr ptr(&x);
    EXPECT_TRUE(ptr.HasTag());
    EXPECT_EQ(static_cast<int*>(ptr), &x);

    ptr.UnTag();
    EXPECT_FALSE(ptr.HasTag());
    EXPECT_EQ(static_cast<int*>(ptr), &x);

    ptr.SetTag(true);
    EXPECT_TRUE(ptr.HasTag());
    EXPECT_EQ(static_cast<int*>(ptr), &x);

    ptr.SetTag(false);
    EXPECT_FALSE(ptr.HasTag());
    EXPECT_EQ(static_cast<int*>(ptr), &x);

    ptr.Tag();
    EXPECT_TRUE(ptr.HasTag());
    EXPECT_EQ(static_cast<int*>(ptr), &x);

    ptr = &y;
    EXPECT_TRUE(ptr.HasTag());
    EXPECT_EQ(static_cast<int*>(ptr), &y);
}

TEST(TRbTreeTest, InsertFind) {
    std::vector<THolder<TTestNode>> memory;
    TTestTree tree;

    for (ui32 i = 1; i <= 1000; i++) {
        auto* node = new TTestNode(i, i * i);
        memory.emplace_back(node);
        tree.Insert(node);
    }

    for (ui32 i = 1000; i > 0; i--) {
        TTestNode* node = tree.Find(i);
        ASSERT_TRUE(node);

        EXPECT_EQ(node->Key, i);
        EXPECT_EQ(node->Value, i * i);
    }
}
