#include "error.h"

#include <solomon/libs/cpp/grpc/status/code.h>

template <>
void Out<NSolomon::TKvClientError>(IOutputStream& os, const NSolomon::TKvClientError& err) {
    if (err.IsTransportError()) {
        os << NGrpc::StatusCodeToString(err.AsTransportError());
    } else {
        os << ::NKikimr::NMsgBusProxy::ToCString(err.AsKvError());
    }
    os << ": " << err.Message();
}
