#pragma once

#include <ydb/public/lib/base/msgbus_status.h>

#include <ydb/core/protos/base.pb.h>

#include <grpc++/support/status_code_enum.h>

namespace NSolomon {

class TKvClientError {
    enum EErrorKind {
        /**
         * Error generated by transport layer, i.e. GRPC client, request limiter or circuit breaker.
         */
        TRANSPORT,

        /**
         * Error generated by YDB host.
         */
        KV,
        /**
         * Error of reply status of protobuf message
         */
        PROTO
    };

public:
    explicit TKvClientError(grpc::StatusCode status, TString message = {}) noexcept
        : Kind_{TRANSPORT}
        , Status_{status}
        , Message_{std::move(message)}
    {
    }

    explicit TKvClientError(::NKikimr::NMsgBusProxy::EResponseStatus status, TString message = {}) noexcept
        : Kind_{KV}
        , Status_{status}
        , Message_{std::move(message)}
    {
    }

    explicit TKvClientError(NKikimrProto::EReplyStatus status, TString message = {}) noexcept
        : Kind_{PROTO}
        , Status_{status}
        , Message_{std::move(message)}
    {
    }

    bool IsTransportError() const noexcept {
        return Kind_ == TRANSPORT;
    }

    grpc::StatusCode AsTransportError() const noexcept {
        Y_VERIFY(IsTransportError());
        return static_cast<grpc::StatusCode>(Status_);
    }

    bool IsKvError() const noexcept {
        return Kind_ == KV;
    }

    ::NKikimr::NMsgBusProxy::EResponseStatus AsKvError() const noexcept {
        Y_VERIFY(IsKvError());
        return static_cast<::NKikimr::NMsgBusProxy::EResponseStatus>(Status_);
    }

    bool IsProtoError() const noexcept {
        return Kind_ == PROTO;
    }

    NKikimrProto::EReplyStatus AsProtoError() const noexcept {
        Y_VERIFY(IsProtoError());
        return static_cast<NKikimrProto::EReplyStatus>(Status_);
    }

    const TString& Message() const noexcept {
        return Message_;
    }

private:
    /**
     * Where does this error come from?
     */
    EErrorKind Kind_;

    /**
     * Depending on `Kind` this is either a `grpc::StatusCode`, or `NKikimr::NMsgBusProxy::EResponseStatus`.
     */
    int Status_;

    /**
     * Human-readable error message.
     */
    TString Message_;
};

} // namespace NSolomon
