#pragma once

#include <util/digest/multi.h>

#include <vector>

namespace NSolomon::NLabels {

struct TInternedLabel {
    TInternedLabel() noexcept
        : Key_{0}
        , Value_{0}
    {
    }

    TInternedLabel(ui32 key, ui32 value) noexcept
        : Key_{key}
        , Value_{value}
    {
    }

    bool operator==(const TInternedLabel& rhs) const = default;
    bool operator!=(const TInternedLabel& rhs) const = default;

    ui32 Key() const noexcept {
        return Key_;
    }

    ui32 Value() const noexcept {
        return Value_;
    }

    size_t Hash() const noexcept {
        return MultiHash(Key_, Value_);
    }

private:
    const ui32 Key_;
    const ui32 Value_;
};

using TInternedLabels = std::vector<TInternedLabel>;

} // namespace NSolomon::NLabels

template <>
struct THash<NSolomon::NLabels::TInternedLabel> {
    size_t operator()(const NSolomon::NLabels::TInternedLabel& label) const {
        return label.Hash();
    }
};

template <>
struct THash<NSolomon::NLabels::TInternedLabels> {
    size_t operator()(const NSolomon::NLabels::TInternedLabels& labels) const {
        size_t hash = 0;
        for (const auto& l: labels) {
            hash = CombineHashes(hash, l.Hash());
        }
        return hash;
    }
};
