#include <library/cpp/testing/gtest/gtest.h>

#include <solomon/libs/cpp/labels/interned.h>

using namespace NSolomon::NLabels;

TEST(TInternedLabelsTest, Empty) {
    TInternedLabels labels;
    EXPECT_EQ(labels.size(), 0u);
}

TEST(TInternedLabelsTest, NonEmpty) {
    TInternedLabels labels{
        { 1, 2 },
        { 3, 4 },
    };

    EXPECT_EQ(labels.size(), 2u);
    EXPECT_EQ(labels[0], TInternedLabel(1, 2));
    EXPECT_EQ(labels[1], TInternedLabel(3, 4));
}

TEST(TInternedLabelsTest, Hash) {
    TInternedLabel l1{1, 2};
    TInternedLabel l2{1, 2};
    TInternedLabel l3{2, 1};

    EXPECT_EQ(l1.Hash(), l2.Hash());
    EXPECT_NE(l1.Hash(), l3.Hash());
    EXPECT_NE(l2.Hash(), l3.Hash());

    TInternedLabels labels{l1, l2, l3};
    EXPECT_NE(THash<TInternedLabels>()(labels), 0u);
}
