#pragma once

#include <util/generic/ptr.h>
#include <util/generic/strbuf.h>

#include <contrib/libs/re2/re2/re2.h>

namespace NSolomon {

// It's a class, not a namespace, because:
// - It could be passed as a template parameter (useful in tests)
class TLabelsValidator {
public:
    static bool ValidateLabelNameSafe(TStringBuf name);
    static void ValidateLabelName(TStringBuf name);
    static bool ValidateLabelValueSafe(TStringBuf value);
    static void ValidateLabelValue(TStringBuf value);
};

class TLabelsValidatorStrict {
public:
    static bool ValidateLabelNameSafe(TStringBuf name);
    static void ValidateLabelName(TStringBuf name);
    static bool ValidateLabelValueSafe(TStringBuf value);
    static void ValidateLabelValue(TStringBuf value);
};

} // namespace NSolomon
