#include "collector.h"

#include <solomon/libs/cpp/metering/shard_metrics_repo.h>
#include <solomon/libs/cpp/shard_metrics/resource_context.h>

namespace NSolomon::NLoadInfo {

using yandex::monitoring::load_info::LoadInfoResponse;

TLoadInfoCollector::TLoadInfoCollector(LoadInfoResponse* response)
    : Response_{response}
{
}

void TLoadInfoCollector::OnShard(TResourceUsageContextHolder& shardCtx) {
    auto* shards = Response_->mutable_shards_load();
    const auto* ctx = dynamic_cast<const TShardMeteringContext*>(shardCtx.Impl());

    Y_VERIFY(ctx->ShardNumId != 0, "shard num id is not initialized");
    shards->add_shard_ids(ctx->ShardNumId);

    // TODO(ivanzhukov@):
//    shards->add_states();

    // TODO(ivanzhukov@):
//    shards->add_uptime_millis();

    shards->add_memory_bytes(ctx->MemoryUsage->Get());
    shards->add_cpu_time_nanos(ctx->CpuUsageUs->Get() * 1'000);
    shards->add_network_bytes(ctx->NetRxBytes->Get() + ctx->NetTxBytes->Get());
}

void TLoadInfoCollector::OnProject(TImmutableMetricRegistry&) {
}

void TLoadInfoCollector::OnTotal(TImmutableMetricRegistry&) {
}

} // namespace NSolomon::NLoadInfo
