#pragma once

#include <solomon/libs/cpp/load_info_service/proto/load_info_grpc_service.pb.h>

#include <util/datetime/base.h>
#include <util/system/info.h>

#include <thread>

namespace NSolomon::NLoadInfo {

inline void GatherHostInfo(yandex::monitoring::load_info::LoadInfoResponse* response) {
    auto* load = response->mutable_host_load();

    // can be inaccurate. For more info, see SOLOMON-7856
    load->set_cpu_time_nanos(TDuration::Seconds(NSystemInfo::CachedNumberOfCpus()).NanoSeconds());
    load->set_memory_bytes(NSystemInfo::TotalMemorySize());
}

} // namespace NSolomon::NLoadInfo
