#include "load_info_service.h"

using namespace NActors;
using namespace yandex::monitoring::load_info;

namespace NSolomon::NLoadInfo {
namespace {

SOLOMON_RPC_HANDLER(LoadInfoService, GetLoadInfo) {
public:
    explicit TGetLoadInfoHandler(TActorId infoProvider)
        : InfoProvider_{infoProvider}
    {}

    void Handle(const NActors::TActorContext&) override {
        Send(InfoProvider_, new TLoadInfoEvents::TGetLoadInfo{SelfId()});
    }

    STATEFN(StateFunc) {
        switch (ev->GetTypeRewrite()) {
            hFunc(TLoadInfoEvents::TGetLoadInfoResult, OnLoadInfo);
        }
    }

private:
    void OnLoadInfo(TLoadInfoEvents::TGetLoadInfoResult::TPtr& ev) {
        const auto& result = ev->Get()->Result;

        if (result.Success()) {
            GetRequestCtx()->Reply(result.Value().get(), grpc::StatusCode::OK);
        } else {
            GetRequestCtx()->ReplyError(grpc::StatusCode::INTERNAL, result.Error().MessageString());
        }

        PassAway();
    }

private:
    TActorId InfoProvider_;
};

class TLoadInfoService final: public NSolomon::NGrpc::TService<LoadInfoService> {
public:
    TLoadInfoService(
            TActorSystem& actorSystem,
            NMonitoring::TMetricRegistry& registry,
            ui32 executorPool,
            TActorId infoProvider)
        : TService{actorSystem, registry, executorPool}
        , InfoProvider_{infoProvider}
    {
    }

private:
    void InitHandlers(grpc::ServerCompletionQueue* cq) override {
        RegisterHandler<TGetLoadInfoHandler>(cq, InfoProvider_);
    }

private:
    TActorId InfoProvider_;
};

} // namespace

TIntrusivePtr<::NGrpc::IGRpcService> CreateLoadInfoService(
        NActors::TActorSystem& actorSystem,
        NMonitoring::TMetricRegistry& registry,
        ui32 executorPool,
        NActors::TActorId infoProvider)
{
    return MakeIntrusive<TLoadInfoService>(actorSystem, registry, executorPool, infoProvider);
}

} // namespace NSolomon::NLoadInfo

