#pragma once

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/error_or/error_or.h>
#include <solomon/libs/cpp/grpc/server/service.h>
#include <solomon/libs/cpp/load_info_service/proto/load_info_grpc_service.grpc.pb.h>

#include <library/cpp/grpc/server/grpc_server.h>

namespace NSolomon::NLoadInfo {

class TLoadInfoEvents: private TEventSlot<EEventSpace::LoadInfo, 0> {
    enum {
        GetLoadInfo = SpaceBegin,
        GetLoadInfoResult,
        Timeout,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TGetLoadInfo: public ::NActors::TEventLocal<TGetLoadInfo, GetLoadInfo> {
        explicit TGetLoadInfo(NActors::TActorId replyTo)
            : ReplyTo{replyTo}
        {
        }

        NActors::TActorId ReplyTo;
    };

    struct TGetLoadInfoResult: public ::NActors::TEventLocal<TGetLoadInfoResult, GetLoadInfoResult> {
        using TResult = TErrorOr<std::unique_ptr<yandex::monitoring::load_info::LoadInfoResponse>, TGenericError>;

        explicit TGetLoadInfoResult(TResult&& result)
            : Result{std::move(result)}
        {
        }

        TResult Result;
    };
};

TIntrusivePtr<::NGrpc::IGRpcService> CreateLoadInfoService(
        NActors::TActorSystem& actorSystem,
        NMonitoring::TMetricRegistry& registry,
        ui32 executorPool,
        NActors::TActorId infoProvider);

} // namespace NSolomon::NLoadInfo

