#pragma once

#include <solomon/libs/cpp/actors/events/events.h>
#include <solomon/libs/cpp/actors/events/slots.h>
#include <solomon/libs/cpp/conf_db/model/shard_config.h>

#include <library/cpp/actors/core/actor.h>
#include <library/cpp/actors/core/event_local.h>
#include <library/cpp/containers/absl_flat_hash/flat_hash_map.h>

namespace NSolomon {

using TNumId = ui32;

class TLocalShardProviderEvents: private TEventSlot<EEventSpace::Libs, ELibSlot::LocalShardProvider> {
    enum {
        LocalShards = SpaceBegin,
        Subscribe,
        End,
    };
    static_assert(End < SpaceEnd, "too many event types");

public:
    struct TLocalShards: public NActors::TEventLocal<TLocalShards, LocalShards> {
        TVector<TNumId> Removed;
        TVector<NDb::NModel::TShardConfig> Updated;
        TVector<NDb::NModel::TShardConfig> Added;

        TLocalShards(
                TVector<TNumId> removed,
                TVector<NDb::NModel::TShardConfig> updated,
                TVector<NDb::NModel::TShardConfig> added)
            : Removed{std::move(removed)}
            , Updated{std::move(updated)}
            , Added{std::move(added)}
        {
        }
    };

    struct TSubscribe: public NActors::TEventLocal<TSubscribe, Subscribe> {
    };
};

std::unique_ptr<NActors::IActor> CreateLocalShardProvider(
        /**
         * Actor listening for new slices (numId assignments) from Slicer
         */
        NActors::TActorId sliceletListener,
        /**
         * Actor periodically downloading configs from a database
         */
        NActors::TActorId configsPuller);

} // namespace NSolomon
