#include <solomon/libs/cpp/actors/test_runtime/actor_runtime.h>
#include <solomon/libs/cpp/clients/slicer/slicelet_listener.h>
#include <solomon/libs/cpp/conf_db/puller/puller.h>
#include <solomon/libs/cpp/local_shard_provider/local_shard_provider.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NActors;
using namespace NSolomon;
using namespace testing;

class TLocalShardProviderTest: public ::testing::Test {
public:
    void SetUp() override {
        ActorRuntime = TTestActorRuntime::CreateInited(1, false, false);
        EdgeId1 = ActorRuntime->AllocateEdgeActor();
        EdgeId2 = ActorRuntime->AllocateEdgeActor();
    }

    void TearDown() override {
        ActorRuntime.Reset();
    }

    THolder<NSolomon::TTestActorRuntime> ActorRuntime;
    TActorId EdgeId1;
    TActorId EdgeId2;
};

TEST_F(TLocalShardProviderTest, Test) {
    auto localShardProvider = ActorRuntime->Register(CreateLocalShardProvider({}, {}).release());
    ActorRuntime->WaitForBootstrap();

    ActorRuntime->Send(new IEventHandle{localShardProvider, EdgeId1, new TLocalShardProviderEvents::TSubscribe});

    yandex::monitoring::slicer::GetSlicesByHostResponse slices;
    slices.add_assigned_starts(1);
    slices.add_assigned_ends(10);

    ActorRuntime->Send(localShardProvider, MakeHolder<NSlicerClient::TSliceletListenerEvents::TSlicesUpdate>(std::move(slices)));

    TConfigs configs;
    for (TNumId i = 8; i != 16; ++i) {
        configs.Shards.emplace_back(NDb::NModel::TShardConfig{ .NumId = i });
    }

    ActorRuntime->Send(localShardProvider, MakeHolder<TConfigsPullerEvents::TConfigsResponse>(std::move(configs)));

    {
        auto ev = ActorRuntime->GrabEdgeEvent<TLocalShardProviderEvents::TLocalShards>(EdgeId1);
        ASSERT_TRUE(ev);

        EXPECT_TRUE(ev->Get()->Removed.empty());
        EXPECT_TRUE(ev->Get()->Updated.empty());

        auto& added = ev->Get()->Added;
        EXPECT_EQ(added.size(), 3u);

        TVector<TNumId> numIds;
        for (const auto& config: added) {
            numIds.emplace_back(config.NumId);
        }

        EXPECT_THAT(numIds, UnorderedElementsAre(8u, 9u, 10u));
    }

    // configs was moved, so it's empty now
    configs.Shards.emplace_back(NDb::NModel::TShardConfig{ .NumId = 7 });  // NOLINT(bugprone-use-after-move)
    configs.Shards.emplace_back(NDb::NModel::TShardConfig{ .NumId = 8, .ProjectId = "project_8" });  // NOLINT(bugprone-use-after-move)

    ActorRuntime->Send(localShardProvider, MakeHolder<TConfigsPullerEvents::TConfigsResponse>(std::move(configs)));  // NOLINT(bugprone-use-after-move)

    {
        auto ev = ActorRuntime->GrabEdgeEvent<TLocalShardProviderEvents::TLocalShards>(EdgeId1);
        ASSERT_TRUE(ev);

        auto& removed = ev->Get()->Removed;
        ASSERT_EQ(removed.size(), 2u);
        EXPECT_THAT(removed, UnorderedElementsAre(9u, 10u));

        auto& updated = ev->Get()->Updated;
        ASSERT_EQ(updated.size(), 1u);
        EXPECT_EQ(updated[0].NumId, 8u);

        auto& added = ev->Get()->Added;
        ASSERT_EQ(added.size(), 1u);
        EXPECT_EQ(added[0].NumId, 7u);
    }

    // new subscriber gets the latest info
    ActorRuntime->Send(new IEventHandle{localShardProvider, EdgeId2, new TLocalShardProviderEvents::TSubscribe});

    {
        auto ev = ActorRuntime->GrabEdgeEvent<TLocalShardProviderEvents::TLocalShards>(EdgeId2);
        ASSERT_TRUE(ev);

        EXPECT_TRUE(ev->Get()->Removed.empty());
        EXPECT_TRUE(ev->Get()->Updated.empty());

        auto& added = ev->Get()->Added;
        ASSERT_EQ(added.size(), 2u);

        TVector<TNumId> numIds;
        for (const auto& config: added) {
            numIds.emplace_back(config.NumId);
        }

        EXPECT_THAT(numIds, UnorderedElementsAre(7u, 8u));
    }
}
