#pragma once

#include <solomon/libs/cpp/timeseries/timeseries.h>

#include <library/cpp/monlib/encode/encoder.h>

#include <util/datetime/base.h>

namespace NSolomon {

enum class ELogFlags : ui8 {
    None = 0,
    Denom = 1 << 0,
    Merge = 1 << 1,
    Count = 1 << 2,
};

// for combination of ELogFlags. E.g. ELogFlags::Count | ELogFlags::Merge
using ELogFlagsComb = std::underlying_type_t<ELogFlags>;

inline ELogFlagsComb CombineLogFlags(ELogFlags flag) {
    return static_cast<ELogFlagsComb>(flag);
}

template <typename... TFlags>
inline ELogFlagsComb CombineLogFlags(ELogFlagsComb flagsComb, TFlags... flags) {
    static_assert(std::conjunction_v<std::is_same<ELogFlags, TFlags>...>);
    return flagsComb | CombineLogFlags(flags...);
}

template <typename... TFlags>
inline ELogFlagsComb CombineLogFlags(ELogFlags flag, TFlags... flags) {
    static_assert(std::conjunction_v<std::is_same<ELogFlags, TFlags>...>);
    return static_cast<ELogFlagsComb>(flag) | CombineLogFlags(flags...);
}

class ILogWriter: public NMonitoring::IMetricEncoder {
public:
    virtual void OnStep(TDuration step) = 0;

    virtual void OnTimeSeries(ELogFlagsComb flags, const TAggrTimeSeries& timeseries) = 0;
    virtual void OnPoint(ELogFlagsComb flags, TAggrPointWithType&& aggrPoint) = 0;

    void OnDouble(TInstant, double) override {
        ythrow yexception() << "method OnDouble() cannot be called on ILogWriter";
    }

    void OnInt64(TInstant, i64) override {
        ythrow yexception() << "method OnInt64() cannot be called on ILogWriter";
    }

    void OnUint64(TInstant, ui64) override {
        ythrow yexception() << "method OnUint64() cannot be called on ILogWriter";
    }

    void OnHistogram(TInstant, NMonitoring::IHistogramSnapshotPtr) override {
        ythrow yexception() << "method OnHistogram() cannot be called on ILogWriter";
    }

    void OnSummaryDouble(TInstant, NMonitoring::ISummaryDoubleSnapshotPtr) override {
        ythrow yexception() << "method OnSummaryDouble() cannot be called on ILogWriter";
    }

    void OnLogHistogram(TInstant, NMonitoring::TLogHistogramSnapshotPtr) override {
        ythrow yexception() << "method OnLogHistogram() cannot be called on ILogWtriter";
    }
};

using ILogWriterPtr = THolder<ILogWriter>;

ILogWriterPtr CreateLogWriter();

} // namespace NSolomon
