#include "math.h"

#include <util/generic/ymath.h>

namespace NSolomon {

// Extension of FuzzyEquals. Inspired by https://www.floating-point-gui.de/errors/comparison/
bool AreDoublesEqual(double a, double b) {
    double diff = Abs(a - b);
    // see DBL_MIN at https://en.cppreference.com/w/cpp/types/climits
    constexpr double minNorm = std::numeric_limits<double>::min();
    constexpr double eps = 1.0e-13; // default value in FuzzyEquals

    if (a == b) { // shortcut for finite values and +-inf
        return true;
    } else if (a == 0 || b == 0 || diff < minNorm) {
        return diff < eps * minNorm;
    } else {
        return FuzzyEquals(a, b, eps);
    }
}

} // namespace NSolomon
