#include "metric_suppliers.h"

namespace NSolomon {
namespace {

using namespace NMonitoring;

class TShardMetricsSupplier: public IMetricSupplier {
private:
    class TRepositoryConsumer: public IRepositoryVisitor {
    public:
        TRepositoryConsumer(TInstant time, IMetricConsumer* consumer)
            : Time_{time}
            , Consumer_{consumer}
        {
        }

    private:
        void OnShard(TResourceUsageContextHolder& shardCtx) override {
            shardCtx.Append(Time_, Consumer_);
        }

        void OnProject(TImmutableMetricRegistry&) override {}
        void OnTotal(TImmutableMetricRegistry&) override {}

    private:
        TInstant Time_;
        IMetricConsumer* Consumer_;
    };

public:
    explicit TShardMetricsSupplier(std::shared_ptr<TShardMeteringMetricsRepository> repo)
        : Repo_{std::move(repo)}
    {
    }

private:
    void Accept(TInstant time, IMetricConsumer* consumer) const override {
        consumer->OnStreamBegin();
        Append(time, consumer);
        consumer->OnStreamEnd();
    }

    void Append(TInstant time, IMetricConsumer* consumer) const override {
        TRepositoryConsumer wrapper{time, consumer};
        Repo_->Visit(wrapper);
    }

private:
    std::shared_ptr<TShardMeteringMetricsRepository> Repo_;
};

class THostMetricsSupplier: public IMetricSupplier {
private:
    class TRepositoryConsumer: public IRepositoryVisitor {
    public:
        TRepositoryConsumer(TInstant time, IMetricConsumer* consumer)
            : Time_{time}
            , Consumer_{consumer}
        {
        }

    private:
        void OnShard(TResourceUsageContextHolder&) override {}
        void OnProject(TImmutableMetricRegistry&) override {}

        void OnTotal(TImmutableMetricRegistry& totals) override {
            totals.Append(Time_, Consumer_);
        }

    private:
        TInstant Time_;
        IMetricConsumer* Consumer_;
    };

public:
    explicit THostMetricsSupplier(std::shared_ptr<TShardMeteringMetricsRepository> repo)
        : Repo_{std::move(repo)}
    {
    }

private:
    void Accept(TInstant time, IMetricConsumer* consumer) const override {
        consumer->OnStreamBegin();
        Append(time, consumer);
        consumer->OnStreamEnd();
    }

    void Append(TInstant time, IMetricConsumer* consumer) const override {
        TRepositoryConsumer wrapper{time, consumer};
        Repo_->Visit(wrapper);
    }

private:
    std::shared_ptr<TShardMeteringMetricsRepository> Repo_;
};

} // namespace

std::unique_ptr<NMonitoring::IMetricSupplier> CreateShardMetricsSupplier(std::shared_ptr<TShardMeteringMetricsRepository> repo) {
    return std::make_unique<TShardMetricsSupplier>(std::move(repo));
}

std::unique_ptr<NMonitoring::IMetricSupplier> CreateHostMetricsSupplier(std::shared_ptr<TShardMeteringMetricsRepository> repo) {
    return std::make_unique<THostMetricsSupplier>(std::move(repo));
}

} // namespace NSolomon
