#include "minidump.h"

#include <library/cpp/monlib/metrics/metric.h>

#include <solomon/libs/cpp/minidump/minidump_path.h>

using namespace NActors;
using namespace NMonitoring;

namespace NSolomon {
namespace {

class TMinidumpCounter: public TSelfPingActor<TMinidumpCounter> {
public:
    TMinidumpCounter(IIntGauge* metric, const TFsPath& minidumpPath, TDuration interval) noexcept
        : TSelfPingActor<TMinidumpCounter>{interval}
        , Metric_{metric}
        , MinidumpPath_{minidumpPath}
    {
    }

    void OnPing(TInstant now, TInstant pingStart) const {
        Y_UNUSED(now, pingStart);
        try {
            TVector <TString> fileNames;
            MinidumpPath_.ListNames(fileNames);
            Metric_->Set(
                std::count_if(fileNames.begin(), fileNames.end(), [](const TString& fileName) {
                    return fileName.EndsWith(".dmp");
                })
            );
        } catch (const yexception& e) {
            // ignore
        }
    }

private:
    IIntGauge* Metric_;
    TFsPath MinidumpPath_;
};

} // namespace

std::unique_ptr<NActors::IActor> CreateMinidumpCounter(NMonitoring::IIntGauge* metric, const TFsPath& minidumpPath, TDuration interval) {
    return std::make_unique<TMinidumpCounter>(metric, minidumpPath, interval);
}

} // namespace NSolomon
