#include <solomon/libs/cpp/minidump/metrics/minidump.h>

#include <solomon/libs/cpp/actors/test_runtime/actor_runtime.h>

#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

#include <util/folder/tempdir.h>

using namespace NSolomon;
using namespace NMonitoring;
using namespace NActors;

class TTMinidumpCounterTest: public ::testing::Test {
protected:
    void SetUp() override {
        ActorRuntime_ = TTestActorRuntime::CreateInited(1, true, false);
        Registry_ = std::make_shared<TMetricRegistry>();
        Counter_ = Registry_->IntGauge(NMonitoring::MakeLabels({{"sensor", "minidump.count"}}));
        ActorRuntime_->Register(CreateMinidumpCounter(Counter_, MinidumpTempDir_.Path(), TDuration::MilliSeconds(10)).release());
    }

    void TearDown() override {
        ActorRuntime_.Reset();
    }

    i64 GetMinidumpCount() const {
        return Counter_->Get();
    }

protected:
    std::shared_ptr<IMetricRegistry> Registry_;
    IIntGauge* Counter_;
    THolder<TTestActorRuntime> ActorRuntime_;
    TTempDir MinidumpTempDir_;
};

TEST_F(TTMinidumpCounterTest, CountMinidumps) {
    MinidumpTempDir_.Path().Child("first.dmp").Touch();
    MinidumpTempDir_.Path().Child("second.dmp").Touch();
    MinidumpTempDir_.Path().Child("first.stack").Touch();
    Sleep(TDuration::MilliSeconds(100));
    ASSERT_EQ(GetMinidumpCount(), 2);
}
