#include "resolve.h"

#include <util/system/execpath.h>
#include <util/generic/yexception.h>

namespace NSolomon {
    llvm::DILineInfo Resolve(uint64_t instructionAddress, llvm::symbolize::LLVMSymbolizer& symbolizer) {
        llvm::symbolize::SectionedAddress address;
        address.Address = instructionAddress - 1; // last byte of the call instruction

        auto symOrErr = symbolizer.symbolizeCode(GetPersistentExecPath(), address);
        Y_ENSURE(symOrErr, "cannot get symbol info for frame" << instructionAddress);
        return symOrErr.get();
    }
}
