#pragma once

#include <util/stream/output.h>
#include <util/stream/input.h>

#include <util/generic/vector.h>

#include <solomon/libs/cpp/multi_shard/proto/multi_shard.pb.h>

namespace NSolomon {
    template <typename TProto>
    class TMessageBase {
    public:
        static constexpr auto LENGTH_HEADER_SIZE = sizeof(ui32);
        static constexpr ui64 MAX_HEADER_SIZE = Max<ui32>();

        TMessageBase() = default;

        // does not copy the data pointed by the argument
        TMessageBase(char* data, ui32 len);
        TMessageBase(TProto proto);

        ui32 Length() const {
            return Length_;
        }

        const TProto& Message() const {
            return *Message_;
        }

    protected:
        void LoadFromStream(IInputStream& is);
        void ToStream(IOutputStream& os) const;

    protected:
        ui32 Length_{0};
        TStringBuf Data_;
        std::optional<TProto> Message_;
    };

    class TMessage: public TMessageBase<TShardData> {
        friend IOutputStream& operator<<(IOutputStream&, const TMessage&);
        friend IInputStream& operator>>(IInputStream&, TMessage&);
    public:
        using TMessageBase<TShardData>::TMessageBase;
        TMessage(TShardData data);
    };

    class THeaderMessage: public TMessageBase<TMultiShardData::THeader> {
        friend IOutputStream& operator<<(IOutputStream&, const THeaderMessage&);
        friend IInputStream& operator>>(IInputStream&, THeaderMessage&);
    public:
        using TMessageBase<TMultiShardData::THeader>::TMessageBase;
        THeaderMessage(TMultiShardData::THeader header);
    };


    IOutputStream& operator<<(IOutputStream& os, const TMessage& message);
    IInputStream& operator>>(IInputStream& is, TMessage& value);

    IOutputStream& operator<<(IOutputStream& os, const THeaderMessage& message);
    IInputStream& operator>>(IInputStream& is, THeaderMessage& value);
} // namespace NSolomon
