#pragma once

#include <library/cpp/monlib/encode/encoder.h>
#include <library/cpp/monlib/encode/format.h>

namespace NSolomon::NMultiShard {
    constexpr TStringBuf JSON_CONTENT_TYPE = "application/x-solomon-multi-json";
    constexpr TStringBuf SPACK_CONTENT_TYPE = "application/x-solomon-multi-spack";
    constexpr TStringBuf TEXT_CONTENT_TYPE = "application/x-solomon-multi-text";

    enum class EFormatVersion: ui32 {
        Min = 0,
        V1,
        Max,
    };

    class THeader {
    public:
        THeader() = default;
        THeader(TString continuationToken, EFormatVersion version = EFormatVersion::V1)
            : ContinuationToken{std::move(continuationToken)}
            , FormatVersion{version}
        {
        }

        TString ContinuationToken;
        EFormatVersion FormatVersion{EFormatVersion::Min};
    };

    class IMultiShardEncoder: public NMonitoring::IMetricEncoder {
    public:
        virtual void SetHeader(THeader header) = 0;
        virtual void OnShardBegin(TString project, TString service, TString cluster = {}) = 0;
        virtual void OnShardEnd() = 0;
    };

    struct IMessageHandler {
        virtual ~IMessageHandler() = default;
        // return false to stop the decoder
        virtual bool OnHeader(THeader header) = 0;
        virtual bool OnShardData(TString project, TString cluster, TString service, TString data) = 0;
        virtual void OnError(TString msg) = 0;
        // always gets called
        virtual void OnStreamEnd() = 0;
    };

    struct IMultiShardContinuousChunkDecoder {
        virtual ~IMultiShardContinuousChunkDecoder() = default;

        virtual void Decode(TStringBuf buf) noexcept = 0;
    };

    using IMultiShardEncoderPtr = THolder<IMultiShardEncoder>;

    IMultiShardEncoderPtr CreateMultiShardEncoder(NMonitoring::EFormat format, IOutputStream& os);
    THolder<IMultiShardContinuousChunkDecoder> CreateMultiShardContinuousChunkDecoder(IMessageHandler& handler);
} // namespace NSolomon
