#pragma once

#include <util/generic/ptr.h>
#include <util/generic/hash.h>
#include <util/generic/vector.h>
#include <util/generic/yexception.h>
#include <util/system/types.h>

namespace NSolomon {

struct TContainerStats {
    struct TNetworkStats {
        TString Name;
        ui64 TxBytes {0};
        ui64 RxBytes {0};
        ui64 TxDrop {0};
        ui64 RxDrop {0};
        ui64 TxPackets {0};
        ui64 RxPackets {0};
    };

    ui64 CpuUsageMillis {0};
    ui64 CpuUsageSystemMillis {0};
    ui64 CpuWaitMillis {0};
    ui64 CpuThrottledMillis {0};
    ui64 CpuLimit {0};
    ui64 CpuGuarantee {0};
    ui64 CpuLimitTotal {0};
    ui64 CpuGuaranteeTotal {0};

    ui64 MemoryUsageBytes {0};
    ui64 AnonUsageBytes {0};
    ui64 AnonMaxUsageBytes {0};
    ui64 CacheUsageBytes {0};
    ui64 MLockUsageBytes {0};
    ui64 MemoryLimit {0};
    ui64 MemoryLimitTotal {0};
    ui64 MemoryGuarantee {0};
    ui64 MemoryGuaranteeTotal {0};
    ui64 AnonLimit {0};
    ui64 AnonLimitTotal {0};
    ui64 MinorPageFaults {0};
    ui64 MajorPageFaults {0};
    ui64 OomKills {0};
    ui64 OomKillsTotal {0};

    ui64 DiskIoReadBytes {0};
    ui64 DiskIoWriteBytes {0};
    ui64 DiskIoTimeMillis {0};

    ui64 TimeSeconds {0};

    THashMap<TString, TNetworkStats> Networks;
};

struct TVolumeStats {
    TString Path;
    ui64 SpaceLimitBytes{0};
    ui64 SpaceAvailableBytes{0};
    ui64 SpaceUsedBytes{0};
};

IOutputStream& operator<<(IOutputStream& os, const NSolomon::TContainerStats& stat);
IOutputStream& operator<<(IOutputStream& os, const NSolomon::TVolumeStats& stat);

class IPortoStatClient: public TThrRefBase {
public:
    virtual TVector<TString> RunningContainers(const TString& filter) = 0;
    virtual TVector<TString> Containers(const TString& filter) = 0;

    virtual TContainerStats Stats(const TString& containerId) = 0;
    virtual TString RawProperty(const TString& containerId, const TString& name) = 0;

    virtual TVector<TVolumeStats> VolumeStats(const TString& containerId) = 0;
};


using IPortoStatClientPtr = TIntrusivePtr<IPortoStatClient>;

IPortoStatClientPtr CreatePortoStatClient();

} // namespace NSolomon
