#pragma once

#include <solomon/libs/cpp/error_or/error_or.h>

#include <util/system/types.h>

namespace NSolomon {
    struct TProcessStats {
        ui64 MemRss{0};
        ui64 MemSwap{0};
        ui64 MemLib{0};

        ui64 MajorPageFaults{0};

        ui16 ThreadCount{0};

        ui32 CpuUser{0};
        ui32 CpuSystem{0};
    };

    struct IProcessStatProvider {
        using TResult = TErrorOr<TProcessStats, TGenericError>;

        virtual ~IProcessStatProvider() = default;
        virtual TResult GetSelfStats() noexcept = 0;
    };

    using IProcessStatProviderPtr = THolder<IProcessStatProvider>;

    IProcessStatProviderPtr CreateProcessStatProvider();
} // namespace NSolomon
