#pragma once

#include <solomon/libs/cpp/error_or/error_or.h>

#include <util/datetime/base.h>
#include <util/system/types.h>

#include <unistd.h>

namespace NSolomon {

inline double TicksPerMicrosec() {
#ifdef _SC_CLK_TCK
    return sysconf(_SC_CLK_TCK) / 1000000.0;
#else
    return 1.f;
#endif
}

struct TThreadStats {
    i64 Pid;
    TString Comm;
    char State;
    i64 Ppid;
    i64 Pgrp;
    i64 Session;
    i64 TtyNr;
    i64 Tpgid;
    ui64 Flags;
    ui64 Minflt;
    ui64 Cminflt;
    ui64 Majflt;
    ui64 Cmajflt;
    // time in this struct is in microseconds
    ui64 Utime;
    ui64 Stime;
    i64 Cutime;
    i64 Cstime;
    i64 Priority;
    i64 Nice;
    i64 NumThreads;
    i64 Itrealvalue;
    ui64 Starttime;
    ui64 Vsize;
    i64 Rss;
    ui64 Rsslim;
    ui64 Startcode;
    ui64 Endcode;
    ui64 Startstack;
    ui64 Kstkesp;
    ui64 Kstkeip;
    ui64 Signal;
    ui64 Blocked;
    ui64 Sigignore;
    ui64 Sigcatch;
    ui64 Wchan;
    ui64 Nswap;
    ui64 Cnswap;
    i64 ExitSignal;
    i64 Processor;
    ui64 RtPriority;
    ui64 Policy;
    ui64 DelayacctBlkioTicks;
    ui64 GuestTime;
    i64 CguestTime;
    ui64 StartData;
    ui64 EndData;
    ui64 StartBrk;
    ui64 ArgStart;
    ui64 ArgEnd;
    ui64 EnvStart;
    ui64 EnvEnd;
    i64 ExitCode;

    bool operator==(const TThreadStats& other) const = default;
};

std::ostream& operator<<(std::ostream& os, const TThreadStats& stats);

struct IThreadStatProvider {
    virtual ~IThreadStatProvider() = default;

    virtual TErrorOr<std::vector<ui64>, TGenericError> GetSelfThreads() noexcept = 0;
    virtual TErrorOr<TThreadStats, TGenericError> GetThreadStats(ui64 tid) noexcept = 0;
};

std::unique_ptr<IThreadStatProvider> CreateThreadStatProvider();
NSolomon::TThreadStats ParseStatLine(const TString& statLine);

} // namespace NSolomon
