#include <solomon/libs/cpp/process_stats/threads_stats.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;

TEST(TParseStatLineTest, ParseStatLine) {
    TString testLine = "12345 (some thread name) D";
    for (size_t i = 0; i < 50; ++i) {
        testLine += " 3254235";
    }
    NSolomon::TThreadStats verify = NSolomon::ParseStatLine(testLine);

    auto ticksPerMicrosec = TicksPerMicrosec();
    const i64 pageSize = sysconf(_SC_PAGESIZE);

    NSolomon::TThreadStats correct;
    correct.Pid = 12345;
    correct.Comm = "some thread name";
    correct.State = 'D';
    correct.Ppid = 3254235;
    correct.Pgrp = 3254235;
    correct.Session = 3254235;
    correct.TtyNr = 3254235;
    correct.Tpgid = 3254235;
    correct.Flags = 3254235;
    correct.Minflt = 3254235;
    correct.Cminflt = 3254235;
    correct.Majflt = 3254235;
    correct.Cmajflt = 3254235;
    correct.Utime = 3254235 / ticksPerMicrosec;
    correct.Stime = 3254235 / ticksPerMicrosec;
    correct.Cutime = 3254235 / ticksPerMicrosec;
    correct.Cstime = 3254235 / ticksPerMicrosec;
    correct.Priority = 3254235;
    correct.Nice = 3254235;
    correct.NumThreads = 3254235;
    correct.Itrealvalue = 3254235;
    correct.Starttime = 3254235 / ticksPerMicrosec;
    correct.Vsize = 3254235;
    correct.Rss = 3254235 * pageSize;
    correct.Rsslim = 3254235;
    correct.Startcode = 3254235;
    correct.Endcode = 3254235;
    correct.Startstack = 3254235;
    correct.Kstkesp = 3254235;
    correct.Kstkeip = 3254235;
    correct.Signal = 3254235;
    correct.Blocked = 3254235;
    correct.Sigignore = 3254235;
    correct.Sigcatch = 3254235;
    correct.Wchan = 3254235;
    correct.Nswap = 3254235;
    correct.Cnswap = 3254235;
    correct.ExitSignal = 3254235;
    correct.Processor = 3254235;
    correct.RtPriority = 3254235;
    correct.Policy = 3254235;
    correct.DelayacctBlkioTicks = 3254235;
    correct.GuestTime = 3254235;
    correct.CguestTime = 3254235;
    correct.StartData = 3254235;
    correct.EndData = 3254235;
    correct.StartBrk = 3254235;
    correct.ArgStart = 3254235;
    correct.ArgEnd = 3254235;
    correct.EnvStart = 3254235;
    correct.EnvEnd = 3254235;
    correct.ExitCode = 3254235;

    ASSERT_EQ(correct, verify);
}
