#include "format.h"

namespace NSolomon {

using yandex::solomon::model::MetricFormat;

MetricFormat ConvertFormatToProto(NMonitoring::EFormat fmt) {
    switch (fmt) {
        case NMonitoring::EFormat::SPACK:
            return MetricFormat::SPACK;
        case NMonitoring::EFormat::JSON:
            return MetricFormat::JSON;
        case NMonitoring::EFormat::UNKNOWN:
            return MetricFormat::METRIC_FORMAT_UNSPECIFIED;
        case NMonitoring::EFormat::PROTOBUF:
        case NMonitoring::EFormat::PROMETHEUS:
        case NMonitoring::EFormat::TEXT:
            Y_VERIFY_DEBUG(false);
            return MetricFormat::METRIC_FORMAT_UNSPECIFIED;
    };
}

NMonitoring::EFormat ConvertProtoFormatToFormat(MetricFormat fmt) {
    switch (fmt) {
        case MetricFormat::METRIC_FORMAT_UNSPECIFIED:
            return NMonitoring::EFormat::UNKNOWN;
        case MetricFormat::SPACK:
            return NMonitoring::EFormat::SPACK;
        case MetricFormat::JSON:
        case MetricFormat::MONITORING_JSON:
            return NMonitoring::EFormat::JSON;
        case MetricFormat::PROMETHEUS:
            return NMonitoring::EFormat::PROMETHEUS;
        case MetricFormat::TEXT:
            return NMonitoring::EFormat::TEXT;
        case MetricFormat::PROTOBUF:
            return NMonitoring::EFormat::PROTOBUF;

        // for compile time checks
        case MetricFormat::MetricFormat_INT_MIN_SENTINEL_DO_NOT_USE_:
        case MetricFormat::MetricFormat_INT_MAX_SENTINEL_DO_NOT_USE_:
            return NMonitoring::EFormat::UNKNOWN;
    }
}

} // namespace NSolomon
