#include "labels.h"
#include <util/string/cast.h>

namespace NSolomon {

NMonitoring::TLabels ReadLabelsFromProto(const yandex::solomon::model::Labels& protoLabels) {
    NMonitoring::TLabels labels;
    // TODO: add reserve() method to TLabels
    for (const auto& label: protoLabels.labels()) {
        labels.Add(label.key(), label.value());
    }
    return labels;
}

void WriteLabelsToProto(yandex::solomon::model::Labels& protoLabels, const NMonitoring::TLabels& nativeLabels) {
    auto* labelsArray = protoLabels.mutable_labels();
    labelsArray->Reserve(nativeLabels.size());

    for (auto& label: nativeLabels) {
        auto* newLabel = labelsArray->Add();
        newLabel->set_key(ToString(label.Name()));
        newLabel->set_value(ToString(label.Value()));
    }
}

} // namespace NSolomon
