#include "metric_type.h"

namespace NSolomon {

using yandex::solomon::model::MetricType;

MetricType ToProto(NMonitoring::EMetricType type) {
    switch (type) {
        case NMonitoring::EMetricType::UNKNOWN: return MetricType::METRIC_TYPE_UNSPECIFIED;
        case NMonitoring::EMetricType::GAUGE: return MetricType::DGAUGE;
        case NMonitoring::EMetricType::COUNTER: return MetricType::COUNTER;
        case NMonitoring::EMetricType::RATE: return MetricType::RATE;
        case NMonitoring::EMetricType::IGAUGE: return MetricType::IGAUGE;
        case NMonitoring::EMetricType::HIST:return MetricType::HIST;
        case NMonitoring::EMetricType::HIST_RATE:return MetricType::HIST_RATE;
        case NMonitoring::EMetricType::DSUMMARY: return MetricType::DSUMMARY;
        case NMonitoring::EMetricType::LOGHIST: return MetricType::LOG_HISTOGRAM;
    }
}

NMonitoring::EMetricType FromProto(yandex::solomon::model::MetricType type) {
    switch (type) {
        case MetricType::DGAUGE: return NMonitoring::EMetricType::GAUGE;
        case MetricType::COUNTER: return NMonitoring::EMetricType::COUNTER;
        case MetricType::RATE: return NMonitoring::EMetricType::RATE;
        case MetricType::IGAUGE: return NMonitoring::EMetricType::IGAUGE;
        case MetricType::HIST: return NMonitoring::EMetricType::HIST;
        case MetricType::HIST_RATE: return NMonitoring::EMetricType::HIST_RATE;
        case MetricType::DSUMMARY: return NMonitoring::EMetricType::DSUMMARY;
        case MetricType::LOG_HISTOGRAM: return NMonitoring::EMetricType::LOGHIST;

        case MetricType::ISUMMARY:
        case MetricType::METRIC_TYPE_UNSPECIFIED:
            return NMonitoring::EMetricType::UNKNOWN;

        // for compile time checks
        case MetricType::MetricType_INT_MIN_SENTINEL_DO_NOT_USE_:
        case MetricType::MetricType_INT_MAX_SENTINEL_DO_NOT_USE_:
            return NMonitoring::EMetricType::UNKNOWN;
    }
}

} // namespace NSolomon
