#include <solomon/libs/cpp/proto_convert/metric_type.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon;
using namespace NMonitoring;
using yandex::solomon::model::MetricType;

std::vector<std::pair<EMetricType, MetricType>> Table = {
        {EMetricType::GAUGE, MetricType::DGAUGE},
        {EMetricType::COUNTER, MetricType::COUNTER},
        {EMetricType::RATE, MetricType::RATE},
        {EMetricType::IGAUGE, MetricType::IGAUGE},
        {EMetricType::HIST, MetricType::HIST},
        {EMetricType::HIST_RATE, MetricType::HIST_RATE},
        {EMetricType::DSUMMARY, MetricType::DSUMMARY},
        {EMetricType::LOGHIST, MetricType::LOG_HISTOGRAM},
        {EMetricType::UNKNOWN, MetricType::METRIC_TYPE_UNSPECIFIED},
};

TEST(TMetricTypeConversionTest, FromProto) {
    for (auto& [cpp, proto]: Table) {
        ASSERT_EQ(cpp, FromProto(proto)) << "invalid conversion of " << MetricTypeToStr(cpp);
    }
}

TEST(TMetricTypeConversionTest, ToProto) {
    for (auto& [cpp, proto]: Table) {
        ASSERT_EQ(proto, ToProto(cpp)) << "invalid conversion of " << MetricTypeToStr(cpp);
    }
}
