#pragma once

#include "search_index.h"
#include "bitmap.h"

#include <solomon/libs/cpp/intern/str_pool.h>

namespace NSolomon::NSearch {
using NSolomon::NIntern::TStringPool;

class IBitmapSegment: public ISearchIndex {
public:
    /**
     *  @return Amount of metrics contained in the index
     */
    virtual size_t Size() const = 0;

    /**
     *  @brief Return all metrics ids
     */
    virtual IBitmapPtr GetAllMetrics() const = 0;

    /**
     *  @brief Mark some ids as removed
     */
    virtual void Remove(const IBitmap& b) = 0;

    virtual size_t AllocatedBytes() const = 0;

public:
    using TPtr = TIntrusivePtr<IBitmapSegment>;
};

THolder<ISearchIndexBuilder> CreateBitmapIndexBuilder(const TAtomicSharedPtr<TStringPool>& interner={});

TIntrusivePtr<IBitmapSegment> CastToSegment(const TIntrusivePtr<ISearchIndex>& object);

ISearchResultPtr CombineSegmentResults(const TVector<ISearchResultPtr>& segmentResults, ui32 max);

TIntrusivePtr<IBitmapSegment> MergeSegments(const TVector<IBitmapSegment::TPtr>& segments);

ISearchResultPtr Truncate(const ISearchResultPtr& segmentResult, ui32 limit);
} // namespace NSolomon::NSearch
