#pragma once

#include "search_index.h"

namespace NSolomon::NSearch {

class TEmptySearchResult final: public ISearchResult {
public:
    size_t Size() const noexcept override {
        return 0;
    }

    ui32 NextId() override {
        return npos;
    }

    TVector<ui32> ToVector() const override {
        return {};
    }
};

class TRangeSearchResult final: public ISearchResult {
public:
    TRangeSearchResult(ui32 fromInclusive, ui32 toExclusive)
        : FromInclusive_(fromInclusive)
        , ToExclusive_(toExclusive)
        , Pos_(fromInclusive)
    {
        Y_ENSURE(toExclusive > fromInclusive);
    }

    size_t Size() const noexcept override {
        return ToExclusive_ - FromInclusive_;
    }

    ui32 NextId() override {
        if (Pos_ >= ToExclusive_) {
            return npos;
        }
        return Pos_++;
    }

    TVector<ui32> ToVector() const override {
        TVector<ui32> result;
        result.reserve(ToExclusive_ - FromInclusive_);
        for (ui32 id = FromInclusive_; id < ToExclusive_; ++id) {
            result.push_back(id);
        }
        return result;
    }

private:
    const ui32 FromInclusive_;
    const ui32 ToExclusive_;
    ui32 Pos_;
};

} // namespace NSolomon::NSearch
