#pragma once

#include <solomon/libs/cpp/selectors/selectors.h>

#include <library/cpp/monlib/metrics/labels.h>

namespace NSolomon::NSearch {

struct ISearchResult {
    using TId = ui32;
    using TPtr = TAtomicSharedPtr<ISearchResult>;
    static constexpr ui32 npos = Max<ui32>();

public:
    virtual ~ISearchResult() = default;

    virtual size_t Size() const noexcept = 0;
    virtual ui32 NextId() = 0;
    virtual TVector<ui32> ToVector() const = 0;
};

class ISearchIndex: public TThrRefBase {
public:
    using TPtr = TIntrusivePtr<ISearchIndex>;

public:
    /**
     *  @return  A list of metrics that match the given selectors
     *  @details
     *           The returned object is valid even after ISearchIndex is destroyed.
     */
    virtual ISearchResult::TPtr Search(const TSelectors& selectors, ui32 max) const = 0;
};

class ISearchIndexBuilder {
public:
    virtual ~ISearchIndexBuilder() = default;

    virtual void Add(const TVector<std::pair<NMonitoring::ILabelsPtr, ui32>>& data) = 0;

    virtual void MarkRemoved(const TVector<ui32>& metricIds) = 0;

    virtual ISearchIndex::TPtr Finalize() = 0;
};

using ISearchResultPtr = ISearchResult::TPtr;
using ISearchIndexPtr = TIntrusivePtr<ISearchIndex>;


} // namespace NSolomon::NSearch
