#pragma once

#include "search_index.h"

namespace NSolomon::NSearch {

/**
 *  Writeable multi-segmented storage
 */
class IStorage : public ISearchIndex, public ISearchIndexBuilder {
public:
    virtual ~IStorage();

    /**
     *  @brief Execute pending Add() operations, if there are any
     */
    virtual void Flush() = 0;

    /**
     *  @return false iff Optimize will have no effect if called
     */
    virtual bool NeedsOptimize() const = 0;

    /**
     *  @brief Merge internal data structures
     */
    virtual bool Optimize() = 0;

    /**
     *  @brief Debug output (for tests)
     */
    virtual TString DebugString(TString key) const = 0;

    virtual size_t AllocatedBytes() const = 0;
};

} // namespace NSolomon::NSearch
