#include <solomon/libs/cpp/search/bitmap.h>

#include <library/cpp/testing/gtest/gtest.h>

#include <contrib/libs/croaring/cpp/roaring.hh>

using namespace NSolomon::NSearch;

TEST(BitmapTest, Optimize) {
    auto bitmap = Optimize(roaring::Roaring{});
    EXPECT_EQ(0u, bitmap->Size());
    bitmap->Consume([](ui32 value) {
        FAIL() << "should not happen, got value" << value;
    });
}

TEST(BitmapTest, Sizes) {
    EXPECT_EQ(16u, Optimize(roaring::Roaring{})->MemBytes());
    EXPECT_EQ(52u, Optimize(roaring::Roaring::bitmapOf(3, 1, 2, 3))->MemBytes());
}
