#include <solomon/libs/cpp/secrets/secrets.h>

#include <library/cpp/testing/gtest/gtest.h>

using namespace NSolomon::NSecrets;

TEST(TSecretProviderTest, ParseNormalStyle) {
    auto provider = StringSecretProvider(R"(
            secrets { key: "one", value: "1111" }
            secrets { key: "two", value: "2222" }
            )");

    auto one = provider->GetSecret("one");
    ASSERT_TRUE(one.has_value());
    ASSERT_EQ("1111", *one);

    auto two = provider->GetSecret("two");
    ASSERT_TRUE(two.has_value());
    ASSERT_EQ("2222", *two);

    auto three = provider->GetSecret("three");
    ASSERT_FALSE(three.has_value());
}

TEST(TSecretProviderTest, ParseJsonStyle) {
    auto provider = StringSecretProvider(R"(
            secrets: [
                { key: "one", value: "1111" },
                { key: "two", value: "2222" }
            ]
            )");

    auto one = provider->GetSecret("one");
    ASSERT_TRUE(one.has_value());
    ASSERT_EQ("1111", *one);

    auto two = provider->GetSecret("two");
    ASSERT_TRUE(two.has_value());
    ASSERT_EQ("2222", *two);

    auto three = provider->GetSecret("three");
    ASSERT_FALSE(three.has_value());
}

TEST(TSecretProviderTest, ParseGoStyle) {
    auto provider = StringSecretProvider(R"(
            secrets: <
              key: "one"
              value: "1111"
            >
            secrets: <
              key: "two"
              value: "2222"
            >
            )");

    auto one = provider->GetSecret("one");
    ASSERT_TRUE(one.has_value());
    ASSERT_EQ("1111", *one);

    auto two = provider->GetSecret("two");
    ASSERT_TRUE(two.has_value());
    ASSERT_EQ("2222", *two);

    auto three = provider->GetSecret("three");
    ASSERT_FALSE(three.has_value());
}

TEST(TSecretProviderTest, YavScheme) {
    auto provider = StringSecretProvider(R"(
            secrets { key: "one", value: "1111" }
            secrets { key: "two", value: "2222" }
            )");

    {
        auto one = provider->GetSecret("one");
        ASSERT_TRUE(one.has_value());
        ASSERT_EQ("1111", *one);
    }

    {
        auto one = provider->GetSecret("yav://one");
        ASSERT_TRUE(one.has_value());
        ASSERT_EQ("1111", *one);
    }
}
