#!/usr/bin/env python3

import os
import hashlib


def calc_hash(filename, chunk_size=4096):
    hasher = hashlib.md5()
    with open(filename, 'rb') as f:
        chunk = f.read(chunk_size)
        while len(chunk) > 0:
            hasher.update(chunk)
            chunk = f.read(chunk_size)
    return hasher.hexdigest()


def get_hash_from_name(filename):
    start = filename.find('.')
    if start == -1:
        raise RuntimeError(f'invalid filename {filename}')

    prefix = filename[0:start]
    end = filename.find('.', start+1)

    if end != -1 and (end - start) == 33:
        # hash is present in filename
        return filename[start+1:end]

    return None


def replace_or_add_hash(filename, hash):
    start = filename.find('.')
    if start == -1:
        raise RuntimeError(f'invalid filename {filename}')

    prefix = filename[0:start]
    end = filename.find('.', start+1)

    if end != -1 and (end - start) == 33:
        # hash is present in filename
        suffix = filename[end+1:]
    else:
        # hash is absent in filename
        suffix = filename[start+1:]
    return f'{prefix}.{hash}.{suffix}'


def main():
    for filename in os.listdir('.'):
        if filename == 'ya.make' or filename == 'update_fingerprints.py':
            continue

        old_hash = get_hash_from_name(filename)
        new_hash = calc_hash(filename)
        if old_hash != new_hash:
            new_filename = replace_or_add_hash(filename, new_hash)
            print(filename, ' => ', new_filename)
            os.rename(filename, new_filename)


if __name__ == '__main__':
    main()
