#include "selfmon.h"

#include <library/cpp/actors/core/actorsystem.h>

namespace NSolomon::NSelfMon {

NActors::TActorId RegisterPage(
        NActors::TActorSystem& actorSystem,
        TString path, TString title,
        std::unique_ptr<NActors::IActor> pageActor,
        bool hiddenFromRootLinks)
{
    auto pageId = actorSystem.Register(pageActor.release());
    RegisterPage(actorSystem, std::move(path), std::move(title), pageId, hiddenFromRootLinks);
    return pageId;
}

void RegisterPage(
        NActors::TActorSystem& actorSystem,
        TString path, TString title,
        NActors::TActorId pageId,
        bool hiddenFromRootLinks)
{
    actorSystem.Send(ServiceId(), new TEvRegisterPage{std::move(path), std::move(title), pageId, hiddenFromRootLinks});
}

} // namespace NSolomon::NSelfMon
